<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/Umsaetze">
		<xsl:comment>erstellt mittels "umsaetze-verdichtung-xml.xsl"</xsl:comment>
		<xsl:processing-instruction name="xml-stylesheet">href="umsaetze-verdichtung-html.xsl" type="text/xsl"</xsl:processing-instruction>
		<xsl:processing-instruction name="cocoon-process">type="xslt"</xsl:processing-instruction>
		<xsl:copy>
			<xsl:element name="Stichtag">
				<xsl:value-of select="@Stichtag"/>
			</xsl:element>
			<xsl:element name="Haben-Gesamtumsaetze">
				<xsl:value-of select="sum(Umsatz[Betrag>'0']/Betrag)"/>
			</xsl:element>
			<xsl:element name="Anzahl-Soll-Gesamtumsaetze">
				<xsl:value-of select="count(Umsatz[Betrag>'0']/Betrag)"/>
			</xsl:element>
			<xsl:element name="Soll-Gesamtumsaetze">
				<xsl:value-of select="sum(Umsatz[not(Betrag>'0')]/Betrag)"/>
			</xsl:element>
			<xsl:element name="Anzahl-Soll-Gesamtumsaetze">
				<xsl:value-of select="count(Umsatz[not(Betrag>'0')]/Betrag)"/>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
